;;
;;  explan.lsp - Express Tools plan replacement command
;;                    
;;
;;  Copyright  1999 by Autodesk, Inc.
;;
;;  Your use of this software is governed by the terms and conditions
;;  of the License Agreement you accepted prior to installation of this
;;  software.  Please note that pursuant to the License Agreement for this
;;  software, "[c]opying of this computer program or its documentation
;;  except as permitted by this License is copyright infringement under
;;  the laws of your country.  If you copy this computer program without
;;  permission of Autodesk, you are violating the law."
;;
;;  AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
;;  AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
;;  MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
;;  DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
;;  UNINTERRUPTED OR ERROR FREE.
;;
;;
;; Description:
;;  Similar to PLAN except that EXPLAN automatically zooms to the center 
;; of the extents of selected objects after performing a plan view to
;; the specified ucs. i.e. In other words; it keeps the zoom distance 
;; consistant.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
(defun c:explan ( / ss c s lst d )
 (acet-error-init 
   (list '( "cmdecho" 0
            "ucsicon" nil
          ) 
         1
         '(setq ACET:UCS-LIST nil)
   );list
 )
 (setq s (getvar "viewsize"))
 (princ "\nSelect objects to zoom to or press <enter> to select everything on screen...")
 (if (and (setq ss (ssget))
          (setq c (acet-geom-ss-extents ss nil))
     );and
     (setq c (acet-geom-midpoint (car c) (cadr c)));setq then
     (progn
      (setq lst (acet-explan-view-extents)
            lst (acet-geom-m-trans lst 0 1)
            lst (acet-geom-cube-points lst)
            lst (acet-geom-list-extents lst)
              c (acet-geom-midpoint (car lst) (cadr lst))
              d (distance (car lst) (cadr lst))
      );setq
      (if (> d s)
          (setq s (/ (+ d s) 2.0));then use the average of the two
      );if
      ;(command "_.line" c pause "")
     );progn else
 );if
 (princ "\nEnter an option [Current ucs/Ucs/World] <Current>: ")
 (command "_.plan")
 (setvar "cmdecho" 1)
 (while (wcmatch (getvar "cmdnames") "*PLAN*")
  (command pause)
 );while
 (setvar "cmdecho" 0)
 (if c
     (command "_.zoom" "_c" c s)
 );if
 (acet-error-restore)
);defun c:explan
 
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Selects everything  on screen and uses the extents of that combined with the screen 
;corcer points to determine the center point (wcs) to use for the zoom after the plan 
;command.
;Returns list of points in wcs
;
(defun acet-explan-view-extents ( / ss p1 p2 p3 p4 lst px )
 (princ "\nSelecting objects on screen...")
 (acet-sysvar-set (list "ucsicon" 0))
 (acet-ucs-cmd (list "_view"))
 (setq  p1 (acet-geom-view-points)
        p2 (cadr p1)
        p1 (car p1)
        px (acet-geom-pixel-unit)
        p1 (list (+ (car p1) px)
                 (+ (cadr p1) px)
                 (caddr p1)
           )
        p2 (list (- (car p2) px)
                 (- (cadr p2) px)
                 (caddr p2)
           )
 );setq
 (if (or (setq ss (ssget "_w" p1 p2))
         (setq ss (ssget "_c" p1 p2))
     );or
     (setq p3 (acet-geom-ss-extents ss nil) ;no shrinkwrap
           p4 (cadr p3)
           p3 (car p3)
           p1 (list (car p1)		;; combine the view extents xy with extents of objects in z
                    (cadr p1)
                    (min (caddr p3) (caddr p4))
              )
           p2 (list (car p2)
                    (cadr p2)
                    (max (caddr p3) (caddr p4))
              )
     );setq then
 );if
 (setq lst (acet-geom-cube-points (list p1 p2)) ;generate the remaining points based on lower left and upper right
       lst (acet-geom-m-trans lst 1 0)
 );setq
 (acet-ucs-cmd (list "_previous"))
 (acet-sysvar-restore)
 (princ "Done")
 lst
);defun acet-explan-view-extents
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Returns a list of 8 points 4 top and 4 bottom.
;
(defun acet-geom-cube-points ( lst / p1 p2 z1 z2 )
 (setq lst (acet-geom-list-extents lst)
        p1 (car lst)
        p2 (cadr lst)
        z1 (min (caddr p1) (caddr p2))
        z2 (max (caddr p1) (caddr p2))
 );setq
 (list (list (car p1) (cadr p1) z1)
       (list (car p2) (cadr p1) z1)
       (list (car p2) (cadr p2) z1)
       (list (car p1) (cadr p2) z1)
       (list (car p1) (cadr p1) z2)
       (list (car p2) (cadr p1) z2)
       (list (car p2) (cadr p2) z2)
       (list (car p1) (cadr p2) z2)
 );list
);defun acet-geom-cube-points


(princ)
;;;-----BEGIN-SIGNATURE-----
;;; agcAADCCB2YGCSqGSIb3DQEHAqCCB1cwggdTAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIFBjCCBQIwggPqoAMCAQICEGS8scfO5NpYadWPHiL76fQw
;;; DQYJKoZIhvcNAQELBQAwfzELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFudGVj
;;; IENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTAw
;;; LgYDVQQDEydTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBDb2RlIFNpZ25pbmcgQ0Ew
;;; HhcNMTUwOTAzMDAwMDAwWhcNMTYwOTAyMjM1OTU5WjCBiDELMAkGA1UEBhMCVVMx
;;; EzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwxFjAUBgNV
;;; BAoMDUF1dG9kZXNrLCBJbmMxHzAdBgNVBAsMFkRlc2lnbiBTb2x1dGlvbnMgR3Jv
;;; dXAxFjAUBgNVBAMMDUF1dG9kZXNrLCBJbmMwggEiMA0GCSqGSIb3DQEBAQUAA4IB
;;; DwAwggEKAoIBAQDqmfToz8wEanfXT+H6tql3aUyaJRWCfFsYPFnGVXIl95fnZY3s
;;; OEfQvFkf9LVte5SwDWkjkReCGJlk4HaRYOTxkd7PkeAOOtYaUSBvULYRlKvAbe2n
;;; +VWwo4yrWATav8d7pKlbMP9f6pYxlaZQzsq/e+pLZwptP8C9Dfrm5OVgCIL/iPRN
;;; Iuvhl9YUZvnkZYmCnihdP4AS8g4d7rfjdxzT653433nO6tgs3fNgnkQQk6EdROwq
;;; esgQXRlH29yRND5xNfup9KiZ7L7Nm7AiM6laNwNIjBwbG4qMWuQ2Ml7hHzQpLaLF
;;; JRV33oHedeGSZ7OmA6+D5WoQtPpSt4YCcub5AgMBAAGjggFuMIIBajAJBgNVHRME
;;; AjAAMA4GA1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzBmBgNVHSAE
;;; XzBdMFsGC2CGSAGG+EUBBxcDMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5zeW1j
;;; Yi5jb20vY3BzMCUGCCsGAQUFBwICMBkaF2h0dHBzOi8vZC5zeW1jYi5jb20vcnBh
;;; MB8GA1UdIwQYMBaAFJY7U/B5M5evfYPvLivMyreGHnJmMCsGA1UdHwQkMCIwIKAe
;;; oByGGmh0dHA6Ly9zdi5zeW1jYi5jb20vc3YuY3JsMFcGCCsGAQUFBwEBBEswSTAf
;;; BggrBgEFBQcwAYYTaHR0cDovL3N2LnN5bWNkLmNvbTAmBggrBgEFBQcwAoYaaHR0
;;; cDovL3N2LnN5bWNiLmNvbS9zdi5jcnQwEQYJYIZIAYb4QgEBBAQDAgQQMBYGCisG
;;; AQQBgjcCARsECDAGAQEAAQH/MA0GCSqGSIb3DQEBCwUAA4IBAQAegWHWPJ8y1kt5
;;; 7JP8TOQlnYs0eMMg5/MHxlW3LhKv/PG8jZ2NDg8YrGuwBC7y3um+PA6KxRT9px8N
;;; KjniMX4NsPtQ81s2EITHy4uFfz6dTpgmL2BLE2/6FPmG4koEhY6zeT4tizeTscOR
;;; Mu1gCtr4Vq+BC/+0Ax6LKOGt5Ut1pJT89ivzZYZOIvEtt9AZRgh7GRg2Oz7X6MFn
;;; c3KudMQhCEnBEUkbS3fmC+kll5PuoF/R1XBcbby0ODfQ3xfwSpNd6WIMr2T5HnSC
;;; gOMmAsuP1Y6LjaCoYDP2mhiwMg797o0XVywnKLEeDGw/F9b/c+lpIBuWGWYnFjz7
;;; CTe7cgdcMYICJDCCAiACAQEwgZMwfzELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5
;;; bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3
;;; b3JrMTAwLgYDVQQDEydTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBDb2RlIFNpZ25p
;;; bmcgQ0ECEGS8scfO5NpYadWPHiL76fQwDQYJKoZIhvcNAQELBQAwDQYJKoZIhvcN
;;; AQEBBQAEggEANgiThd0tsUs/28gLmuJJNE0v7AVNViuhllvIOLDHCi/jMqKM4QTj
;;; ff7Jn/tRSuH0MfA+yOu+60eNBiGs/aWRVns80LhHxJdK8t5YtVEjRFLGx7en1lcc
;;; qdW7rdOGs6Yc/qK6fSluD/7g1G3pXgusxU6zQk6T2oQCTtG51OjfAp9/L1tJBZO4
;;; VEcTuY7XQYuCHpyJ2WUct/Q57phnyaRB3KOPHIZu2171/xjaF/yuyrtTabwRarDL
;;; X0c8/d3h1claMbsfVRyb8P3pecu2ToSJOeaxu884S8997XlPkH5gT7xWKTMv0xXK
;;; V6lLCHjGtzlcpm1TznlK/rp5AIqnw3PmGaFjMGEGA1UdDjFaBFg0ADAAOwAyAC8A
;;; NwAvADIAMAAxADYALwA0AC8AMwA4AC8AMQA1AC8AVABpAG0AZQAgAGYAcgBvAG0A
;;; IAB0AGgAaQBzACAAYwBvAG0AcAB1AHQAZQByAAAA
;;; -----END-SIGNATURE-----